﻿<%@ WebService Language="VB" Class="VPS" %>

Imports System
Imports System.Web
Imports System.Web.Services
Imports System.Web.Services.Protocols
Imports MachSol.MachPanel.DBCore
Imports MachSol.MachPanel.RemoteServer.VPS.HyperV
Imports System.Data
Imports System.Data.SqlClient 

<WebService(Namespace:="http://machsol.com/")> _
<WebServiceBinding(ConformsTo:=WsiProfiles.BasicProfile1_1)> _
<System.Web.Script.Services.ScriptService()> _
Public Class VPS
    Inherits System.Web.Services.WebService
    
    <WebMethod(EnableSession:=True)> _
    Public Function getVPSState(ByVal VPSId As Long, ByVal State As String) As String
        Dim RetVal As String = ""
        
        Dim vps As New VPSAccount(VPSId)
        
        If (vps.VPSState = VPSAccount.VPSStateOptions.Provisioning) Then
            RetVal = "0|" & Resources.Content.M0125 & "|" & vps.VPSStateDescription
        ElseIf (vps.VPSState = VPSAccount.VPSStateOptions.Blocked) Then
            RetVal = "1|" & Resources.Content.SPT002527 & "|" & vps.VPSStateDescription
        ElseIf (vps.VPSState = VPSAccount.VPSStateOptions.Ready) Then
            RetVal = "2|" & Resources.Content.SPT002209 & "|" & vps.VPSStateDescription
        ElseIf (vps.VPSState = VPSAccount.VPSStateOptions.ErrorCase) Then
            RetVal = "3|" & "Error" & "|" & vps.VPSStateDescription
        Else
            RetVal = "3|" & "Error" & "|" & vps.VPSStateDescription
        End If
        
        If (State = "State") Then
            Dim VPSProv As New VPSProvisioning(vps.VPSServerId)
           
            Try
                Dim MS As MachineEnabledStates = VPSProv.GetVirtualMachineState(vps.VMID)
                RetVal += " Current State """ & MS.ToString() & """"
            Catch ex As Exception
                RetVal = "3|" & "Error" & "|" & vps.VPSStateDescription
            End Try
                   
        End If
        
        If (State = "Migrate") Then
            Dim VPSProv As New VPSProvisioning(vps.VPSServerId)
            
            Dim Result = CreateObject("Scripting.Dictionary")

            Dim VPServerGroupId As Long = 0

            VPServerGroupId = VPSServerDataProxy.SelectVPSServerById(vps.VPSServerId).Tables(0).Rows(0)("VPSServerGroupId")

            Dim DT As DataTable = VPSServerDataProxy.VPSServerSelectByVPSServerGroupID(VPServerGroupId).Tables(0)

            For Each Row As DataRow In DT.Rows
                Try
                    VPSProv = New VPSProvisioning(Row("VPSServerId"))
                    Result = VPSProv.GetVMDetails(vps.VMName)

                    If Result.item("Status").ToString.ToLower = "operating normally" Then 'Move completed successfully
                        vps.VPSState = VPSAccount.VPSStateOptions.Ready
                        vps.VPSStateDescription = ""
                        vps.VPSServerId = Row("VPSServerId")
                        RetVal = "2|" & Resources.Content.SPT002209 & "|" & Resources.Content.EGN0000011
                        Exit For
                    ElseIf Result.item("Status").ToString.ToLower.Contains("migrating") Or Result.item("Status").ToString.ToLower.Contains("in service") _
                        Or Result.item("Status").ToString.ToLower.Contains("saving") Then 'Move under process
                        'Still migrating
                        RetVal = "1|" & Resources.Content.SPT002527 & "|" & Resources.Content.VPS1002
                        Exit For
                    Else 'Error case
                        vps.VPSState = VPSAccount.VPSStateOptions.ErrorCase
                        vps.VPSStateDescription = Result.item("Status").ToString
                        vps.VPSServerId = Row("VPSServerId")
                        RetVal = "3|" & "Error" & "|" & vps.VPSStateDescription
                        Exit For
                    End If

                Catch err As Exception
                    'Move to next item
                End Try
            Next

            vps.Commit()
          
                            
        End If

        Return RetVal

    End Function

    <WebMethod(EnableSession:=True)> _
    Public Function UpdateAlertViewedOn(ByVal EmployeeId As Long, ByVal IsEmployee As Boolean) As Boolean
        Dim Success As Boolean = False
        Try
            MachSol.MachPanel.DBCore.SystemSettings.UpdateAlertViewedOn(DateTime.Now, EmployeeId, IsEmployee)
            Success = True
        Catch ex As Exception
            Success = False
        End Try
        Return Success
    End Function
    
    <WebMethod(EnableSession:=True)> _
    Public Function SynchAlertOperations(ByVal CompanyId As String, ByVal EmployeeId As String, ByVal IsEmployee As Boolean) As String
        Dim Success As String = 0
        Dim DSet As New DataSet
            
        Try
            Dim DS As New DataSet
            Dim SDR As SqlDataReader = MachSol.MachPanel.DBCore.SystemSettings.SynchAlertsInDB(EmployeeId, IsEmployee)
            SDR.Read()
            Success = SDR("RowCounter")
            SDR.Close()
            MachSol.MachPanel.DBCore.SystemSettings.GetAlertOperations(CompanyID, EmployeeID, IsEmployee, DS, "Alerts")
            If Session("BillingEnabled") IsNot Nothing And Convert.ToBoolean(Session("BillingEnabled")) = False Then
                DS.Tables("Alerts").DefaultView.RowFilter = "ModuleTypeID<>1"
            Else
                'Rep_Subscription.DataSource = DS.Tables("Alerts").DefaultView
            End If
            
            Dim DT As New DataTable("Alerts")
            DT.Columns.Add("Description")
            DT.Columns.Add("Success")
            Dim DisplayCount As Integer = 0
            For Each DR As DataRow In DS.Tables("Alerts").DefaultView.ToTable.Rows
                Dim DRow As DataRow = DT.NewRow
                
                Dim Param As String = DR("URLInfo")
                Dim Description As String = DR("Description")
                Description = Description.Replace("Trans_Id:AM002", Resources.Content.AM002)
                Description = Description.Replace("Trans_Id:AM003", Resources.Content.AM003)
                Description = Description.Replace("Trans_Id:AM004", Resources.Content.AM004)
                Description = Description.Replace("Trans_Id:AM005", Resources.Content.AM005)
                Description = Description.Replace("Trans_Id:AM006", Resources.Content.AM006)
                Description = Description.Replace("Trans_Id:AM007", Resources.Content.AM007)
                Description = Description.Replace("Trans_Id:AM008", Resources.Content.AM008)
                Description = Description.Replace("Trans_Id:AM009", Resources.Content.AM009)
                Description = Description.Replace("Trans_Id:AM010", Resources.Content.AM010)
                Description = Description.Replace("Trans_Id:AM011", Resources.Content.AM011)
                Description = Description.Replace("Trans_Id:AM012", Resources.Content.AM012)
                Description = Description.Replace("Trans_Id:AM013", Resources.Content.AM013)
                Description = Description.Replace("Trans_Id:AM014", Resources.Content.AM014)
                Description = Description.Replace("Trans_Id:AM015", Resources.Content.AM015)
                Description = Description.Replace("Trans_Id:AM016", Resources.Content.AM016)
                Description = Description.Replace("Trans_Id:AM017", Resources.Content.AM017)
                Description = Description.Replace("Trans_Id:AM018", Resources.Content.AM018)
                
                Dim DateCreated As DateTime = DR("DateCreated")
                Dim TimeEllapsed As String = DateTime.Now.Subtract(DateCreated).TotalMinutes
                TimeEllapsed = Convert.ToInt32(Convert.ToDouble(TimeEllapsed))
                
                If TimeEllapsed < 1 Then
                    TimeEllapsed = "Less then a Minute"
                ElseIf TimeEllapsed >= 1 And TimeEllapsed < 30 Then
                    TimeEllapsed = TimeEllapsed & " Minute(s) Ago"
                ElseIf TimeEllapsed = 30 Then
                    TimeEllapsed = "Half an Hour Ago"
                ElseIf TimeEllapsed > 30 And TimeEllapsed < 60 Then
                    TimeEllapsed = TimeEllapsed & " Minute(s) Ago"
                ElseIf TimeEllapsed > 60 Then
                    TimeEllapsed = Convert.ToInt32(Convert.ToInt32(TimeEllapsed) / 60)
                    TimeEllapsed = TimeEllapsed & " Hour(s) Ago"
                End If
                Dim BaseURL As String = MachSol.MachPanel.DBCore.Common.GetBaseURL(CompanyId) 'Session("CWURL")
                BaseURL = BaseURL.TrimEnd("/")
                If DR("ModuleTypeID") = "1" Then
                    DRow("Description") = "<a style='text-decoration: none;' href='" & BaseURL & "/RCC/Billing/Documents.aspx' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/dollar.gif' alt='Billing Manager'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                ElseIf DR("ModuleTypeID") = "2" Then
                    'DRow("Description") = "<a style='text-decoration: none;' href='" & BaseURL & "/RCC/HelpDesk/ViewTickets.aspx' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/support.gif' alt='Helpdesk Manager'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                    DRow("Description") = "<a style='text-decoration: none;' href='" & BaseURL & "/RCC/HelpDesk/ViewTicketDetail.aspx?TicketId=" & Param.Split("|")(0) & "' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/support.gif' alt='Helpdesk Manager'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                ElseIf DR("ModuleTypeID") = "3" Then
                    'DRow("Description") = "<a style='text-decoration: none;' href='" & BaseURL & "/RCC/Clients/Subscriptions.aspx' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/icon_subscriptions.gif' alt='Subscriptions'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                    Dim SubsURL As String = BaseURL & "/RCC/Clients/Subscriptions.aspx"
                    Dim PackageTypeID As String = Param.Split("|")(1)
                    If PackageTypeID = 1 Then
                        SubsURL = BaseURL & "/RCC/Clients/SH.aspx?Id=" & Param.Split("|")(0)
                    ElseIf PackageTypeID = 2 Then
                        SubsURL = BaseURL & "/RCC/Clients/NH.aspx?Id=" & Param.Split("|")(0)
                    ElseIf PackageTypeID = 5 Then
                        SubsURL = BaseURL & "/RCC/Clients/DH.aspx?Id=" & Param.Split("|")(0)
                    ElseIf PackageTypeID = 8 Then
                        SubsURL = BaseURL & "/RCC/Clients/SSL.aspx?Id=" & Param.Split("|")(0)
                    ElseIf PackageTypeID = 10 Then
                        SubsURL = BaseURL & "/RCC/Clients/Domain.aspx?Id=" & Param.Split("|")(0)
                    ElseIf PackageTypeID = 14 Then
                        SubsURL = BaseURL & "/RCC/Clients/CRM.aspx?SubId=" & Param.Split("|")(0)
                    ElseIf PackageTypeID = 16 Then
                        SubsURL = BaseURL & "/RCC/Clients/ExH.aspx?SubId=" & Param.Split("|")(0)
                    ElseIf PackageTypeID = 17 Then
                        SubsURL = BaseURL & "/RCC/Clients/SP.aspx?SubId=" & Param.Split("|")(0)
                    ElseIf PackageTypeID = 18 Then
                        SubsURL = BaseURL & "/RCC/Clients/OCS.aspx?SubId=" & Param.Split("|")(0)
                    ElseIf PackageTypeID = 5 Then
                        SubsURL = BaseURL & "/RCC/Clients/VPS.aspx?SubId=" & Param.Split("|")(0)
                    End If
                    DRow("Description") = "<a style='text-decoration: none;' href='" & SubsURL & "' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/icon_subscriptions.gif' alt='Subscriptions'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                ElseIf DR("ModuleTypeID") = "4" Then
                    'DRow("Description") = "<a style='text-decoration: none;' href='" & BaseURL & "/RCC/Clients/ClientsList.aspx' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/icon_clients.gif' alt='Customer Manager'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                    'dev4:8080/RCC/Clients/ClientDetail.aspx?cID=1981&Src=C.
                    If Param.Split("|")(1) = 0 Then
                        DRow("Description") = "<a style='text-decoration: none;' href='" & BaseURL & "/RCC/Clients/ClientDetail.aspx?cID=" & Param.Split("|")(0) & "&Src=C' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/icon_clients.gif' alt='Customer Manager'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                    Else
                        DRow("Description") = "<a style='text-decoration: none;' href='" & BaseURL & "/RCC/Clients/ClientDetail.aspx?RD=1&CID=" & Param.Split("|")(0) & "' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/icon_clients.gif' alt='Customer Manager'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                        DRow("Description") = DRow("Description").ToString.Replace("customer", "reseller")
                    End If
                ElseIf DR("ModuleTypeID") = "5" Then
                    'DRow("Description") = "<a style='text-decoration: none;' href='" & BaseURL & "/RCC/Network/ServiceDirector/ServiceQueue.aspx' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/icon_service_q.gif' alt='Customer Manager'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                    Dim PackageTypeId As String = Param.Split("|")(1)
                    Dim ActionType As String = Param.Split("|")(2)
                    Dim AccountID As String = Param.Split("|")(3)
                    Dim ActionText As String, Hosting As String = ""
                    If ActionType = "0" Then
                        ActionText = "Provision"
                    ElseIf ActionType = "1" Then
                        ActionText = "Cancel"
                    ElseIf ActionType = "3" Then
                        ActionText = "Suspend"
                    ElseIf ActionType = "4" Then
                        ActionText = "Resume"
                    ElseIf ActionType = "5" Then
                        ActionText = "Edit"
                    ElseIf ActionType = "8" Then
                        ActionText = "Add organization"
                    End If

                    If PackageTypeId = "1" Then
                        Hosting = "Shared Hosting"
                    ElseIf PackageTypeId = "2" Then
                        Hosting = "Reseller Hosting"
                    ElseIf PackageTypeId = "5" Then
                        Hosting = "Dedicated Server Hosting"
                    ElseIf PackageTypeId = "8" Then
                        Hosting = "SSL Hosting"
                    ElseIf PackageTypeId = "10" Then
                        Hosting = "Domain Name Product"
                    ElseIf PackageTypeId = "14" Then
                        Hosting = "CRM Hosting"
                    ElseIf PackageTypeId = "16" Then
                        Hosting = "Exchange Hosting"
                    ElseIf PackageTypeId = "17" Then
                        Hosting = "Sharepoint Hosting"
                    ElseIf PackageTypeId = "18" Then
                        Hosting = "Lync Hosting"
                    ElseIf PackageTypeId = "19" Then
                        Hosting = "VPS Hosting"
                    End If

                    Dim DomainName As String = ""
                    Try
                        SDR = MachSol.MachPanel.DBCore.SystemSettings.GetHostingByPackageTypeID(PackageTypeId, AccountID)
                        SDR.Read()
                        If PackageTypeId = 14 Or PackageTypeId = 16 Or PackageTypeId = 18 Then
                            DomainName = Resources.Content.DGN1110608 & ": " & SDR("OrgName") & ", " & Resources.Content.GN000125 & ": " & SDR("DomainName")
                        ElseIf PackageTypeId = 5 Then
                            DomainName = Resources.Content.GN0000980 & ": " & SDR("ReferenceID")
                        ElseIf PackageTypeId = 2 Then
                            DomainName = ""
                        ElseIf PackageTypeId = 17 Then
                            DomainName = Resources.Content.String521 & ": " & SDR("PortalName") & ", " & Resources.Content.GN000125 & ": " & SDR("DomainName")
                        ElseIf PackageTypeId = 19 Then
                            DomainName = Resources.Content.VPS002 & ": " & SDR("VPSName")
                        Else
                            DomainName = Resources.Content.GN000125 & ": " & SDR("DomainName")
                        End If
                        SDR.Close()
                    Catch ex As Exception
                        DomainName = ""
                    End Try
                    Description = Resources.Content.AM013 & "," & ActionText & " " & Hosting & " AccountID: " & AccountID & ", " & DomainName
                    Description = Description.Trim(",")
                    DRow("Description") = "<a style='text-decoration: none;' href='" & BaseURL & "/RCC/Network/ServiceDirector/ServiceQueue.aspx' ><img src='" & BaseURL & "/App_Themes/Default/Images/icons/icon_service_q.gif' alt='Customer Manager'>&nbsp;" & Description & "</a><br />&nbsp;<img src='" & BaseURL & "/App_Themes/Default/Images/icons/alert.gif' alt=''>&nbsp;" & TimeEllapsed
                End If
                DRow("Success") = Success
                DT.Rows.Add(DRow)
                
                'Display top 10 Records only
                DisplayCount = DisplayCount + 1
                If DisplayCount >= 10 Then
                    Exit For
                End If
            Next
            DSet.Tables.Add(DT)
        Catch ex As Exception
            Success = 0
        End Try
        Return DSet.GetXml()
    End Function
    
End Class
